/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)97	1.3  src/avs/fs/mmfs/ts/kernext/ibm-kxi/cxiAtomic.h, mmfs, avs_remp, rempt1d1 10/12/01 00:22:38 */

/*
 * Support for platform independant SMP synchronization operations
 *
 * $Id: cxiAtomic.h,v 1.3 2001/10/11 14:04:58 gjertsen Exp $
 *
 * $Log: cxiAtomic.h,v $
 * Revision 1.3  2001/10/11 14:04:58  gjertsen
 * Provide support for 64-bit mutex lockword (LOCKWORD64).
 *
 * Revision 1.2  2000/12/15 13:57:06  gjertsen
 * Clean up documentation.
 *
 * Revision 1.1  2000/10/31 15:42:31  gjertsen
 * Insert atomic operations into cxi layer.
 *
 *
 */

#ifndef _h_cxiAtomic
#define _h_cxiAtomic

/* Include platform specific interfaces */
#include <cxiAtomic-plat.h>

/* Platform independant interface */

/* 32-bit invariant atomic operations */
#define ATOMIC_ADD(_v,_i) fetch_and_add((atomic_p)(_v), (int)(_i))
#define ATOMIC_AND(_v,_i) fetch_and_and((atomic_p)(_v), (uint)(_i))
#define ATOMIC_OR(_v,_i) fetch_and_or((atomic_p)(_v), (uint)(_i))
#define ATOMIC_SWAP(_v, _p, _i) compare_and_swap((atomic_p)(_v), (int *)(_p), (int)(_i))
#ifdef _KERNEL
#define ATOMIC_SET(_v,_i) test_and_set((atomic_p)(_v), (int)(_i))
#endif /* _KERNEL */

/* 32-bit invariant macros with "no addresses" required for args */
#define ATOMIC_ADD_NA(_v, _i) fetch_and_add((atomic_p)&(_v), (int)(_i))

/* Variable size atomic operations (32/64-bit) */
/* These should be used with longs and pointers, ie, the natural word width */
#ifdef __64BIT__
#define ATOMIC_ADDLP(_v,_i) fetch_and_addlp((atomic_l)(_v), (long)(_i))
#define ATOMIC_ANDLP(_v,_i) fetch_and_andlp((atomic_l)(_v), (ulong)(_i))
#define ATOMIC_ORLP(_v,_i) fetch_and_orlp((atomic_l)(_v), (ulong)(_i))
#define ATOMIC_SWAPLP(_v, _p, _i) compare_and_swaplp((atomic_l)(_v), (long *)(_p), (long)(_i))
#ifdef _KERNEL
#define ATOMIC_SETLP(_v,_i) test_and_setlp((atomic_l)(_v), (long)(_i))
#endif /* _KERNEL */
#else /* _ILP32 */
#define ATOMIC_ADDLP(_v,_i) ATOMIC_ADD(_v, _i)
#define ATOMIC_ANDLP(_v,_i) ATOMIC_AND(_v, _i)
#define ATOMIC_ORLP(_v,_i) ATOMIC_OR(_v, _i)
#define ATOMIC_SWAPLP(_v, _p, _i) ATOMIC_SWAP(_v, _p, _i)
#ifdef _KERNEL
#define ATOMIC_SETLP(_v,_i) ATOMIC_SET(_v, _i)
#endif
#endif /* __64BIT__ */

/* 64-bit invariant atomic operations */
#ifdef __64BIT__
#define ATOMIC_ADD64(_v,_i) ATOMIC_ADDLP(_v, _i)
#define ATOMIC_AND64(_v,_i) ATOMIC_ANDLP(_v,_i)
#define ATOMIC_OR64(_v,_i) ATOMIC_ORLP(_v,_i)
#define ATOMIC_SWAP64(_v, _p, _i) ATOMIC_SWAPLP(_v, _p, _i)
#ifdef _KERNEL
#define ATOMIC_SET64(_v,_i) ATOMIC_SETLP(_v, _i) 
#endif /* _KERNEL */
#endif /* __64BIT__ */

/* Mutex lockword operations */
#if defined(LOCKWORD64) && !defined(__64BIT__)
#error 64-bit lockword only for 64-bit environment!
#endif /* LOCKWORD64 */
#if defined(LOCKWORD64)
#define CHECK_LOCK(_v, _i1, _i2) _check_locklp((atomic_l)(_v), (long)(_i1), (long)(_i2))
#define LOCKWORD_SWAP  ATOMIC_SWAP64
#define LOCKWORD_OR    ATOMIC_OR64
#define LOCKWORD_AND   ATOMIC_AND64
#else
#define CHECK_LOCK(_v, _i1, _i2) _check_lock((atomic_p)(_v), (int)(_i1), (int)(_i2))
#define LOCKWORD_SWAP  ATOMIC_SWAP
#define LOCKWORD_OR    ATOMIC_OR
#define LOCKWORD_AND   ATOMIC_AND
#endif /* LOCKWORD64 */

#endif /* _h_cxiAtomic */
